# -*- coding: utf-8 -*-
"""
Réseau de 2 neurones sans activation pour modéliser un AND
"""

import numpy as np
import matplotlib.pyplot as plt
import tensorflow as tf
from matplotlib.colors import ListedColormap

# DONNEES SOURCES
X_train = np.array([[0,0],
              [0,1],
              [1,0],
              [1,1]])     
y_train = np.array(X_train[:,0]*X_train[:,1])    # AND binaire

# Affichage données sources
colors = ListedColormap(['red', 'green'])
scatter= plt.scatter(X_train[:,0], X_train[:,1], c=y_train, cmap=colors)
plt.xlabel('x1')
plt.ylabel('x2')
plt.legend(*scatter.legend_elements() )  
plt.axis('equal')
plt.show()


# B1 - Création du réseau
def aucune(x):                          # fonction d'activation linéaire
    return x

mon_reseau = tf.keras.Sequential()      # du type réseau par couche
mon_reseau.add(tf.keras.layers.Dense(   # 1ère COUCHE cachée
    units = 2,                          # nb neurones pour la couche
    input_shape = (2,),                 # nb entrée pour chaque neurone à spécifier pour le 1er couche cachée 
    activation = aucune ))              # fonction d'activation classique

mon_reseau.add(tf.keras.layers.Dense(   # modifé: ajout couche de sortie linéaire
    units = 1,activation = aucune))     # modifié 

# B2 - Configuration de la procédure d'apprentissage
opt = tf.keras.optimizers.Adam(learning_rate=0.09) # modifié : learning rate modifiable 
mon_reseau.compile(optimizer = opt,   # algo d'apprentissage
    loss = 'binary_crossentropy',       # somme des erreurs commises: écart entre valeur prédite et réelle
    metrics = ['accuracy'])             # mesure le taux de succès : nb de bonnes réponses / nb de questions

# B3 - Apprentissage du réseau
histoire = mon_reseau.fit(x = X_train,  # données d'entrée pour apprentissage
    y = y_train,                        # étiquettes associées ou sorties désirées
    epochs = 500,                        # modifié : nb cycle d'apprentissage suffisant
    batch_size = len(X_train),            # modifié : dataset complet 
    verbose=False)                       # des informations à chaque itération de lot




# AFFICHAGE RESULTATS
def aff_RNA():
    """Affiche les frontières de décision d'un modèle Réseau de neurones Artificiel"""
    x1 = np.linspace(0, 1, 100)
    x2 = np.linspace(0, 1, 100)
    X1, X2 = np.meshgrid(x1, x2)
    grid_data = list(zip(X1.ravel(), X2.ravel()))
    y = mon_reseau.predict(grid_data)
    y = (y>0).astype(int).reshape(X1.shape)
    colors = ListedColormap(['red', 'green'])
    scatter= plt.scatter(X_train[:,0], X_train[:,1], c=y_train, cmap=colors)
    plt.contourf(X1, X2, y, cmap=colors, alpha=0.2) # alpha réaugmenté
    plt.xlabel('x1')
    plt.ylabel('x2')
    plt.legend(*scatter.legend_elements() )  
    plt.axis('equal')
    plt.title("Prédiction d'un RNA")
    plt.show()

def aff_perf():
    print('precision', histoire.history['accuracy'][-1]) # modifié : erreur affichage
    print('loss',histoire.history['loss'][-1]) # modifié : erreur affichage
    plt.figure(figsize = (18,6))           
    plt.subplot(1,2,1)                                       
    plt.plot(histoire.history['accuracy'])            
    plt.xlabel('Epoch Number')              
    plt.ylabel("Accuracy [0-1]")            
    plt.ylim([0, 1])                      
    plt.grid()
    plt.subplot(1,2,2)                                             
    plt.plot(histoire.history['loss'])               
    plt.xlabel('Epoch Number')
    plt.ylabel("Loss Magnitude")
    plt.xscale('log')                       
    plt.ylim([0, 4])                     
    plt.xlim([1, max(plt.xlim())])         
    plt.grid()
    plt.show()

aff_RNA()
aff_perf()
